/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Random;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public abstract class SwayingBlockTile
extends class_2586
implements IExtraModelDataProvider {
    public static final ModelDataKey<Boolean> FANCY = ModBlockProperties.FANCY;
    protected static float maxSwingAngle = 45.0f;
    protected static float minSwingAngle = 2.5f;
    protected static float maxPeriod = 25.0f;
    protected static float angleDamping = 150.0f;
    protected static float periodDamping = 100.0f;
    private float angle = 0.0f;
    private float prevAngle = 0.0f;
    private int animationCounter = 800 + new Random().nextInt(80);
    private boolean inv = false;
    protected boolean shouldHaveTESR = false;
    protected boolean currentlyHasTESR = false;
    private int ticksToSwitchMode = 0;

    protected SwayingBlockTile(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state);
    }

    public boolean isAlwaysFast() {
        return ClientConfigs.Blocks.FAST_LANTERNS.get();
    }

    public ExtraModelData getExtraModelData() {
        this.ticksToSwitchMode = 2;
        return ExtraModelData.builder().with(FANCY, (Object)this.shouldHaveTESR).build();
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void setFancyRenderer(boolean fancy) {
        if (this.isAlwaysFast()) {
            fancy = false;
        }
        if (fancy != this.shouldHaveTESR) {
            this.currentlyHasTESR = this.shouldHaveTESR;
            this.shouldHaveTESR = fancy;
            if (this.field_11863 == class_310.method_1551().field_1687) {
                this.requestModelReload();
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 8);
            }
            if (!fancy) {
                this.animationCounter = 800;
            }
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public boolean shouldRenderFancy() {
        if (this.currentlyHasTESR != this.shouldHaveTESR && !this.currentlyHasTESR) {
            this.currentlyHasTESR = true;
        }
        return this.currentlyHasTESR;
    }

    public static void clientTick(class_1937 pLevel, class_2338 pPos, class_2680 pState, SwayingBlockTile tile) {
        if (tile.currentlyHasTESR != tile.shouldHaveTESR && tile.currentlyHasTESR && tile.ticksToSwitchMode > 0) {
            --tile.ticksToSwitchMode;
            if (tile.ticksToSwitchMode == 0) {
                tile.currentlyHasTESR = false;
            }
        }
        if (tile.shouldRenderFancy()) {
            ++tile.animationCounter;
            double timer = tile.animationCounter;
            if (((Boolean)pState.method_11654((class_2769)WaterBlock.WATERLOGGED)).booleanValue()) {
                timer /= 2.0;
            }
            tile.prevAngle = tile.angle;
            float a = minSwingAngle;
            float k = 0.01f;
            if (timer < 800.0) {
                a = (float)Math.max((double)maxSwingAngle * Math.exp(-(timer / (double)angleDamping)), (double)minSwingAngle);
                k = (float)Math.max(Math.PI * 2 * (double)((float)Math.exp(-(timer / (double)periodDamping))), (double)0.01f);
            }
            tile.angle = (tile.angle = a * class_3532.method_15362((float)((float)(timer / (double)maxPeriod - (double)k)))) * (tile.inv ? -1.0f : 1.0f);
        }
    }

    public float getSwingAngle(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevAngle, (float)this.angle);
    }

    public abstract class_2382 getNormalRotationAxis(class_2680 var1);

    public void hitByEntity(class_1297 entity, class_2680 state, class_2338 pos) {
        class_243 mot = entity.method_18798();
        if (mot.method_1033() > 0.05) {
            class_2382 dv;
            class_243 vec;
            class_243 norm = new class_243(mot.field_1352, 0.0, mot.field_1350).method_1029();
            double dot = norm.method_1026(vec = new class_243((double)(dv = this.getNormalRotationAxis(state)).method_10263(), 0.0, (double)dv.method_10260()).method_1029());
            if (dot != 0.0) {
                boolean bl = this.inv = dot < 0.0;
            }
            if (Math.abs(dot) > 0.4) {
                if (this.animationCounter > 10) {
                    class_1657 p;
                    class_1657 player;
                    class_1657 class_16572 = player = entity instanceof class_1657 ? (p = (class_1657)entity) : null;
                    if (state.method_26204() instanceof HangingSignBlock) {
                        entity.method_37908().method_8396(player, pos, class_3417.field_24064, class_3419.field_15245, 0.5f, 2.0f);
                        entity.method_37908().method_8396(player, pos, class_3417.field_14718, class_3419.field_15245, 0.75f, 2.0f);
                    } else {
                        entity.method_37908().method_8396(player, pos, state.method_26231().method_10596(), class_3419.field_15245, 0.75f, 1.5f);
                    }
                }
                this.animationCounter = 0;
            }
        }
    }

    public boolean isFlipped() {
        return false;
    }
}

